import bpy
from pathlib import Path, PurePosixPath

class OLI_OT_AbsoluteTexturePaths(bpy.types.Operator):
    """Tooltip"""
    bl_idname = "object.absolute_texture_paths"
    bl_label = "Absolute Texture Paths"

    @classmethod
    def poll(cls, context):
        return context.active_object is not None

    def absolute_path(self, srcpath, relpath):
        """
        srcpath is relative to relpath.
        this is making it absolute.
        """

        if srcpath[0:4]!="//..":
            return srcpath

        src=srcpath.replace("//","").split("\\")
        rel=relpath.split("\\")[:-1]
        while src:
            if src[0]=="..":
                src.pop(0)
                rel.pop()
            else:
                break

        return "\\".join(rel)+"\\"+"\\".join(src)

    def main(self, context):
        src=bpy.data.filepath
        for img in bpy.data.images:
            if img.source=="FILE":
                img.filepath=self.absolute_path(img.filepath, src)
                
    def execute(self, context):
        self.main(context)
        return {'FINISHED'}

class OLI_OT_RelativeTexturePaths(bpy.types.Operator):
    """Tooltip"""
    bl_idname = "object.relative_texture_paths"
    bl_label = "Relative Texture Paths"

    @classmethod
    def poll(cls, context):
        return context.active_object is not None

    def relative_path(self, srcpath,relpath):
        """
        srcpath is absolute.
        this makes it relative to relpath
        """

        # already relative?
        if srcpath[0:4]=="//..":
            print(f"AR: {srcpath[0:4]}")
            return srcpath

        src=srcpath.replace("//","").split("\\")
        rel=relpath.split("\\")[:-1]

        # Even on same drive?
        if src[0]!=rel[0]:
            print(f"FF: {src[0]} == {rel[0]}")
            return srcpath

        pos=1
        while src[pos]==rel[pos]:
            pos+=1

        return "//"+"\\".join([".."]*(len(rel)-pos)+src[pos:])

    def main(self, context):
        rel=bpy.data.filepath
        for img in bpy.data.images:
            if img.source=="FILE":
                img.filepath=self.relative_path(img.filepath,rel)
                
    def execute(self, context):
        self.main(context)
        return {'FINISHED'}

class VIEW3D_PT_AbsoluteTexturePathsPanel(bpy.types.Panel):
    bl_space_type="VIEW_3D"
    bl_region_type="UI"
    bl_category="Tool"
    bl_label="Set tex-paths to absolute."

    def draw(self, context):
        layout = self.layout
        box = layout.box()
        box.operator("object.absolute_texture_paths", text="Absolute Tex Paths" )
        box.operator("object.relative_texture_paths", text="Relative Tex Paths" )        

def register():
    bpy.utils.register_class(OLI_OT_AbsoluteTexturePaths)
    bpy.utils.register_class(OLI_OT_RelativeTexturePaths)
    bpy.utils.register_class(VIEW3D_PT_AbsoluteTexturePathsPanel)


def unregister():
    bpy.utils.unregister_class(OLI_OT_AbsoluteTexturePaths)
    bpy.utils.unregister_class(OLI_OT_RelativeTexturePaths)
    bpy.utils.unregister_class(VIEW3D_PT_AbsoluteTexturePathsPanel)

if __name__ == "__main__":
    register()

    # test call
    # bpy.ops.object.absolute_texture_paths()
    # bpy.ops.object.relative_texture_paths()

